-------------------------------------------------------------------------------------------------------------------
-- THEMEPREFS SCRIPT
-------------------------------------------------------------------------------------------------------------------
local function OptionNameString(str)
	return THEME:GetString('OptionNames',str)
end

local Prefs = {
	-- ThemePref Root rows used with OptionRoot script file.
	ShowCombo = { Default = "EMPTY", Choices = { "Empty" }, Values = { "EMPTY" } },
	ShowRoulette = { Default = "EMPTY", Choices = { "Empty" }, Values = { "EMPTY" } },
	ShowRandom = { Default = "EMPTY", Choices = { "Empty" }, Values = { "EMPTY" } },
	
	-- Standard ThemePref rows.
	ScoreGradeWeights =
	{
		Default = "MQX",
		Choices = { "Metro Quad X", "Stepmania 5" },
		Values = { "MQX", "SM5" }
	},
	TimingWindow =
	{
		Default = "MQX",
		Choices = { "Metro Quad X", "Stepmania 5" },
		Values = { "MQX", "SM5" }
	},
}
ThemePrefs.InitAll(Prefs)

function InitUserPrefs()
	local Prefs = {
		UserPrefScoringMode = 'MIGS',
        UserPrefSoundPack   = 'default',
		UserPrefProtimingP1 = false,
		UserPrefProtimingP2 = false,
	}
	for k, v in pairs(Prefs) do
		-- kind of xxx
		local GetPref = type(v) == "boolean" and GetUserPrefB or GetUserPref
		if GetPref(k) == nil then
			SetUserPref(k, v)
		end
	end
	-- screen filter
	setenv("ScreenFilterP1",0)
	setenv("ScreenFilterP2",0)
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: EditorNoteskin
-------------------------------------------------------------------------------------------------------------------
function OptionRootEditorNoteskin()
	local Noteskins = NOTESKIN:GetNoteSkinNames()
	local t = {
		Name = "OptionRootEditorNoteskin",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = Noteskins,
		LoadSelections = function(self, list, pn)
			local userNoteSkin = PREFSMAN:GetPreference("EditorNoteSkinP1")
			local i = FindInTable(userNoteSkin, Noteskins) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#list do
				if list[i] then
					sSave = Noteskins[i]
					PREFSMAN:SetPreference("EditorNoteSkinP1",sSave)
					PREFSMAN:SetPreference("EditorNoteSkinP2",sSave)
					PREFSMAN:SavePreferences()
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: Combo
-------------------------------------------------------------------------------------------------------------------
function OptionRootCombo()
	local t = {
		Name="ScreenRootCombo",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = true,
		Choices = { "Show", "Hide" },
		LoadSelections = function(self, list, pn)
			local LoadValue = ThemePrefs.Get("ShowCombo")
			if LoadValue == "EMPTY" then
				list[1] = true
			elseif LoadValue == "Show" then
				list[1] = true
			else
				list[2] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				ThemePrefs.Set("ShowCombo","Show")
				ThemePrefs.ForceSave()
			end
			if list[2] then
				ThemePrefs.Set("ShowCombo","Hide")
				ThemePrefs.ForceSave()
			end
		end,
	};
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: MusicWheel Roulette
-------------------------------------------------------------------------------------------------------------------
function OptionRootRoulette()
	local t = {
		Name="ScreenRootRoulette",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = true,
		Choices = { "Show", "Hide" },
		LoadSelections = function(self, list, pn)
			local LoadValue = ThemePrefs.Get("ShowRoulette")
			if LoadValue == "EMPTY" then
				list[1] = true
			elseif LoadValue == "Show" then
				list[1] = true
			else
				list[2] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				ThemePrefs.Set("ShowRoulette","Show")
				ThemePrefs.ForceSave()
			end
			if list[2] then
				ThemePrefs.Set("ShowRoulette","Hide")
				ThemePrefs.ForceSave()
			end
		end,
	};
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: MusicWheel Random
-------------------------------------------------------------------------------------------------------------------
function OptionRootRandom()
	local t = {
		Name="ScreenRootRandom",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { "Show", "Hide" },
		LoadSelections = function(self, list, pn)
			local LoadValue = ThemePrefs.Get("ShowRandom")
			if LoadValue == "EMPTY" then
				list[1] = true
			elseif LoadValue == "Show" then
				list[1] = true
			else
				list[2] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				ThemePrefs.Set("ShowRandom","Show")
				ThemePrefs.ForceSave()
			end
			if list[2] then
				ThemePrefs.Set("ShowRandom","Hide")
				ThemePrefs.ForceSave()
			end
		end,
	};
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: AdditionalCourseFolders
-------------------------------------------------------------------------------------------------------------------
function OptionRootAdditionalCourseFolders()
	local choice = { "Enter Value", PREFSMAN:GetPreference("AdditionalCourseFolders") }
	if choice[2] == "" then choice[2] = "None" end
	local t = {
		Name = "OptionRootAdditionalCourseFolders",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectMultiple",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = choice,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				--PREFSMAN:SetPreference("EditorNoteSkinP1",sSave)
				--PREFSMAN:SavePreferences()
			end
		end,
		NotifyOfSelection = function(self, pn, choice)
			local Choices = self.Choices
			for i = 1,#Choices do
				if choice == i then
					SCREENMAN:SystemMessage(Choices[i])
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: AdditionalFolders
-------------------------------------------------------------------------------------------------------------------
function OptionRootAdditionalFolders()
	local choice = { PREFSMAN:GetPreference("AdditionalFolders") }
	if choice[1] == "" then choice[1] = "None" end
	local t = {
		Name = "OptionRootAdditionalFolders",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = choice,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				--PREFSMAN:SetPreference("EditorNoteSkinP1",sSave)
				--PREFSMAN:SavePreferences()
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: AdditionalSongFolders
-------------------------------------------------------------------------------------------------------------------
function OptionRootAdditionalSongFolders()
	local choice = { PREFSMAN:GetPreference("AdditionalSongFolders") }
	if choice[1] == "" then choice[1] = "None" end
	local t = {
		Name = "OptionRootAdditionalSongFolders",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = choice,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				--PREFSMAN:SetPreference("EditorNoteSkinP1",sSave)
				--PREFSMAN:SavePreferences()
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: AllowExtraStage
-------------------------------------------------------------------------------------------------------------------
function OptionRootAllowExtraStage()
	local choice = { "Enabled", "Disabled" }
	local pref = "AllowExtraStage"
	local t = {
		Name = "OptionRootAllowExtraStage",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = choice,
		LoadSelections = function(self, list, pn)
			local userPref = PREFSMAN:GetPreference(pref) == true and "Enabled" or "Disabled"
			local i = FindInTable(userPref, choice) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#list do
				if list[i] then
					local sSave
					if choice[i] == "Enabled" then sSave = true else sSave = false end
					PREFSMAN:SetPreference(pref,sSave)
					PREFSMAN:SavePreferences()
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: AllowMultipleHighScoreWithSameName
-------------------------------------------------------------------------------------------------------------------
function OptionRootAllowMultipleHighScoreWithSameName()
	local choice = { "Enabled", "Disabled" }
	local pref = "AllowMultipleHighScoreWithSameName"
	local t = {
		Name = "OptionRootAllowMultipleHighScoreWithSameName",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = choice,
		LoadSelections = function(self, list, pn)
			local userPref = PREFSMAN:GetPreference(pref) == true and "Enabled" or "Disabled"
			local i = FindInTable(userPref, choice) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#list do
				if list[i] then
					local sSave
					if choice[i] == "Enabled" then sSave = true else sSave = false end
					PREFSMAN:SetPreference(pref,sSave)
					PREFSMAN:SavePreferences()
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: AllowMultipleInstances
-------------------------------------------------------------------------------------------------------------------
function OptionRootAllowMultipleInstances()
	local choice = { "Enabled", "Disabled" }
	local pref = "AllowMultipleInstances"
	local t = {
		Name = "OptionRootAllowMultipleInstances",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = choice,
		LoadSelections = function(self, list, pn)
			local userPref = PREFSMAN:GetPreference(pref) == true and "Enabled" or "Disabled"
			local i = FindInTable(userPref, choice) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#list do
				if list[i] then
					local sSave
					if choice[i] == "Enabled" then sSave = true else sSave = false end
					PREFSMAN:SetPreference(pref,sSave)
					PREFSMAN:SavePreferences()
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: AllowMultitextures
-------------------------------------------------------------------------------------------------------------------
function OptionRootAllowMultitexture()
	local choice = { "Enabled", "Disabled" }
	local pref = "AllowMultitexture"
	local t = {
		Name = "OptionRootAllowMultitexture",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = choice,
		LoadSelections = function(self, list, pn)
			local userPref = PREFSMAN:GetPreference(pref) == true and "Enabled" or "Disabled"
			local i = FindInTable(userPref, choice) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#list do
				if list[i] then
					local sSave
					if choice[i] == "Enabled" then sSave = true else sSave = false end
					PREFSMAN:SetPreference(pref,sSave)
					PREFSMAN:SavePreferences()
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: AllowSongDeletion
-------------------------------------------------------------------------------------------------------------------
function OptionRootAllowSongDeletion()
	local choice = { "Enabled", "Disabled" }
	local pref = "AllowSongDeletion"
	local t = {
		Name = "OptionRootAllowSongDeletion",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = choice,
		LoadSelections = function(self, list, pn)
			local userPref = PREFSMAN:GetPreference(pref) == true and "Enabled" or "Disabled"
			local i = FindInTable(userPref, choice) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#list do
				if list[i] then
					local sSave
					if choice[i] == "Enabled" then sSave = true else sSave = false end
					PREFSMAN:SetPreference(pref,sSave)
					PREFSMAN:SavePreferences()
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: AllowUnacceleratedRenderer
-------------------------------------------------------------------------------------------------------------------
function OptionRootAllowUnacceleratedRenderer()
	local choice = { "Enabled", "Disabled" }
	local pref = "AllowUnacceleratedRenderer"
	local t = {
		Name = "OptionRootAllowUnacceleratedRenderer",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = choice,
		LoadSelections = function(self, list, pn)
			local userPref = PREFSMAN:GetPreference(pref) == true and "Enabled" or "Disabled"
			local i = FindInTable(userPref, choice) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#list do
				if list[i] then
					local sSave
					if choice[i] == "Enabled" then sSave = true else sSave = false end
					PREFSMAN:SetPreference(pref,sSave)
					PREFSMAN:SavePreferences()
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: AnisotropicFiltering
-------------------------------------------------------------------------------------------------------------------
function OptionRootAnisotropicFiltering()
	local choice = { "Enabled", "Disabled" }
	local pref = "AnisotropicFiltering"
	local t = {
		Name = "OptionRootAnisotropicFiltering",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = choice,
		LoadSelections = function(self, list, pn)
			local userPref = PREFSMAN:GetPreference(pref) == true and "Enabled" or "Disabled"
			local i = FindInTable(userPref, choice) or 1
			list[i] = true
		end,
		SaveSelections = function(self, list, pn)
			local sSave
			for i=1,#list do
				if list[i] then
					local sSave
					if choice[i] == "Enabled" then sSave = true else sSave = false end
					PREFSMAN:SetPreference(pref,sSave)
					PREFSMAN:SavePreferences()
				end
			end
		end
	}
	return t
end

-------------------------------------------------------------------------------------------------------------------
-- OptionRoot: Announcer
-------------------------------------------------------------------------------------------------------------------
function OptionRootAnnouncer()
	local choice = { PREFSMAN:GetPreference("Announcer") }
	if choice[1] == "" then choice[1] = "None" end
	local t = {
		Name = "OptionRootAnnouncer",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = choice,
		LoadSelections = function(self, list, pn)
			list[1] = true
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				--PREFSMAN:SetPreference("EditorNoteSkinP1",sSave)
				--PREFSMAN:SavePreferences()
			end
		end
	}
	return t
end